function Activation_frames1=CheckActivationFrame(Stack,Framenrs,NewFrame)
% Checks the position of activation pulses, based on the intensity of the stack
% Discontinuities in the activation stack can be accounted for using the optional NewFrame 
% variable, based on the displayed graph
SizeStack = size(Stack);
if SizeStack(1)<100 | SizeStack(2)<100
    coords_centre = [0 SizeStack(1)-1 0 SizeStack(2)-1];
else
    coords_centre = [round(SizeStack(1)/2-49) round(SizeStack(1)/2+50) round(SizeStack(2)/2-49) round(SizeStack(2)/2+50)];
end
MeanIntTrace = double(squeeze(mean(mean(Stack(coords_centre(1):coords_centre(2),coords_centre(3):coords_centre(4),:),[],1),[],2)));

if ~exist('NewFrame','var') | isempty(NewFrame)==1
    Activation_frames1 = (Framenrs:Framenrs:size(MeanIntTrace,2)-1)';
    Activation_frames2 = ((Framenrs+1):Framenrs:size(MeanIntTrace,2))';
    
    figure
    hold on
    plot([0:size(MeanIntTrace,2)-2],MeanIntTrace(1:(end-1)))
    plot(Activation_frames1(1:(end-1)),MeanIntTrace(Activation_frames2(1:(end-1))),'m+')
    hold off
    xlabel('Frame')
    ylabel('Mean intensity')
else
    Activation_frames1 = (Framenrs:Framenrs:NewFrame(1)-1)';
    Activation_frames2 = ((Framenrs+1):Framenrs:NewFrame(1))';
    for ii=1:(size(NewFrame,2)-1)
        Activation_frames1 = [Activation_frames1; (NewFrame(ii):Framenrs:(NewFrame(ii+1)-1))'];
        Activation_frames2 = [Activation_frames2; ((NewFrame(ii)+1):Framenrs:NewFrame(ii+1))'];
    end
    Activation_frames1 = [Activation_frames1; (NewFrame(end):Framenrs:size(MeanIntTrace,2)-1)'];
    Activation_frames2 = [Activation_frames2; ((NewFrame(end)+1):Framenrs:size(MeanIntTrace,2))'];
    
    figure
    hold on
    plot([0:size(MeanIntTrace,2)-2],MeanIntTrace(1:(end-1)))
    plot(Activation_frames1(1:(end-1)),MeanIntTrace(Activation_frames2(1:(end-1))),'m+')
    hold off
    xlabel('Frame')
    ylabel('Mean intensity')
end