function newdrift=Import_ThSTORM_Drift(nrbeads,stacksize,name)
% Imports drift characteristics derived from beads isolated and analysed with ThunderSTORM

% Import data from ThunderSTORM results
for jj=1:nrbeads
    filename=strcat(name,'_Drift/ThSTORM_Bead',num2str(jj),'.csv');
    Pre{jj} = Import_ThunderSTORM_results(filename);
end;clear kk jj

% Isolate coordinates and frame number
for jj=1:nrbeads
    coords = Pre{jj}.frame;
    coords(:,2)=Pre{jj}.Results.x;
    coords(:,3)=Pre{jj}.Results.y;
    Loc_Pre{jj} = coords;
    clear coords
end; clear jj

% Make sure only localisation per image
% Convert coordinate to drift, with respect to the position in first image
newdrift= zeros(stacksize,2,nrbeads);
for kk=1:nrbeads
    for jj=2:stacksize      % frame = jj
        ind = find(Loc_Pre{kk}(:,1)==jj);
        if size(ind,1) == 0      % no localisation found: use previous value
            newdrift(jj,:,kk) = newdrift(jj-1,:,kk);
        elseif size(ind,1) == 1      % only one localisation for this frame
            newdrift(jj,1,kk) = Loc_Pre{kk}(ind,2)-Loc_Pre{kk}(1,2);
            newdrift(jj,2,kk) = Loc_Pre{kk}(ind,3)-Loc_Pre{kk}(1,3);
        else                        % multiple localisations: use closest to previous
            ind_use=find(((Loc_Pre{kk}(ind,2) - Loc_Pre{kk}(ind(1)-1,2)).^2 + (Loc_Pre{kk}(ind,3) - Loc_Pre{kk}(ind(1)-1,3)).^2) == min((Loc_Pre{kk}(ind,2) - Loc_Pre{kk}(ind(1)-1,2)).^2+(Loc_Pre{kk}(ind,3) - Loc_Pre{kk}(ind(1)-1,3)).^2));
            newdrift(jj,1,kk) = Loc_Pre{kk}(ind(ind_use),2)-Loc_Pre{kk}(1,2);
            newdrift(jj,2,kk) = Loc_Pre{kk}(ind(ind_use),3)-Loc_Pre{kk}(1,3);
        end
    end
end;clear jj kk

% Plot drift
f=figure;set(gcf,'position',[500,650,1200,450]);
subplot(1,2,1)
hold on
for jj=1:nrbeads
    plot(newdrift(:,1,jj),newdrift(:,2,jj),'+','LineStyle','none','DisplayName', ['Bead ' num2str(jj)]);
end
hold off
xlabel('x drift (nm)');
ylabel('y drift (nm)');
legend('show')
title('All beads');
subplot(1,2,2);
hold on
plot(median(newdrift(:,1,:),3), median(newdrift(:,2,:),3),'+','LineStyle','none','Color','k');
plot(mean(newdrift(:,1,:),3), mean(newdrift(:,2,:),3),'+','LineStyle','none','Color','r');
xlabel('x drift (nm)');
ylabel('y drift (nm)');
title('Combined drift of all beads');
legend({'Median value','Mean value'})
clear f
print(strcat(name,'Drift_Scatter'),'-depsc')

f=figure;
p = uipanel('Parent',f,'BorderType','none'); 
p.Title = strcat('Drift for',{' '},name); 
p.TitlePosition = 'centertop'; 
p.FontSize = 12;
p.FontWeight = 'bold';
subplot(2,1,1,'Parent',p);
for jj=1:nrbeads
    hold on
        plot(newdrift(:,1,jj),'DisplayName', ['Bead ' num2str(jj)]);
        ylabel('x drift (nm)');
end
legend('show')
subplot(2,1,2,'Parent',p);
for jj=1:nrbeads
    hold on
        plot(newdrift(:,2,jj));
        ylabel('y drift (nm)');
end
xlabel('image');
clear f
print(strcat(name,'Drift_Trace'),'-depsc')