function Check_Drift_correction(nrbeads,subset,stacksize,name,shifts_before)
% Checks the alignment, by comparing drift of beads before and after aligning the datastack

% Import data from ThunderSTORM results
for jj=1:nrbeads
    filename=strcat(name,'_Drift/ThSTORM_Bead',num2str(jj),'_Aligned.csv');
    Pre{jj} = Import_ThunderSTORM_results(filename);
end;clear kk jj

% Isolate coordinates and frame number
for jj=1:nrbeads
    coords = Pre{jj}.frame;
    coords(:,2)=Pre{jj}.Results.x;
    coords(:,3)=Pre{jj}.Results.y;
    Loc_Pre{jj} = coords;
    clear coords
end; clear jj

% Make sure only localisation per image and converts coordinates to image shifts, with respect to the position in first image
newdrift= zeros(stacksize,2,nrbeads);
for kk=1:nrbeads
    for jj=2:stacksize      % frame = jj
        ind = find(Loc_Pre{kk}(:,1)==jj);
        if size(ind,1) == 0      % no localisation found: use previous value
            newdrift(jj,:,kk) = newdrift(jj-1,:,kk);
        elseif size(ind,1) == 1      % only one localisation for this frame
            newdrift(jj,1,kk) = Loc_Pre{kk}(ind,2)-Loc_Pre{kk}(1,2);
            newdrift(jj,2,kk) = Loc_Pre{kk}(ind,3)-Loc_Pre{kk}(1,3);
        else                        % multiple localisations: use closest to previous
            ind_use=find(((Loc_Pre{kk}(ind,2) - Loc_Pre{kk}(ind(1)-1,2)).^2 + (Loc_Pre{kk}(ind,3) - Loc_Pre{kk}(ind(1)-1,3)).^2) == min((Loc_Pre{kk}(ind,2) - Loc_Pre{kk}(ind(1)-1,2)).^2+(Loc_Pre{kk}(ind,3) - Loc_Pre{kk}(ind(1)-1,3)).^2));
            newdrift(jj,1,kk) = Loc_Pre{kk}(ind(ind_use),2)-Loc_Pre{kk}(1,2);
            newdrift(jj,2,kk) = Loc_Pre{kk}(ind(ind_use),3)-Loc_Pre{kk}(1,3);
        end
    end
end;clear jj kk

% Plot time-traces for all beads
figure
subplot(2,1,1);hold on
for ii=1:nrbeads
    plot(newdrift(:,1,ii),'DisplayName', ['Bead ' num2str(ii)])
end
legend('show')
ylabel('x coord (nm)')
subplot(2,1,2);hold on
for ii=1:nrbeads
    plot(newdrift(:,2,ii),'DisplayName', ['Bead ' num2str(ii)])
end
legend('show')
ylabel('y coord (nm)')
print(strcat(name,'Drift_remainder'),'-depsc')

vectors_x= newdrift(:,1,1)*0;
vectors_y= newdrift(:,2,1)*0;
for kk=subset
    vectors_x=[vectors_x newdrift(:,1,kk)];
    vectors_y=[vectors_y newdrift(:,2,kk)];
end
Shifts_x=mean(vectors_x(2:end,:),2);
Shifts_y=mean(vectors_y(2:end,:),2);

% Plot histograms
figure
subplot(2,2,1);
hist(shifts_before(:,1),200)
xlabel('x coord, before (nm)')
subplot(2,2,2);
hist(Shifts_x,200)
xlabel('x coord, after (nm)')
subplot(2,2,3);
hist(shifts_before(:,2),200)
xlabel('y coord, before (nm)')
subplot(2,2,4);
hist(Shifts_y,200)
xlabel('y coord, after (nm)')
print(strcat(name,'Drift_histograms'),'-depsc')

% Plot time-traces
figure
subplot(2,1,1);hold on
plot(shifts_before(:,1))
plot(Shifts_x)
ylabel('x coord (nm)')
legend('before correction','after correction')
subplot(2,1,2);hold on
plot(shifts_before(:,2))
plot(Shifts_y)
ylabel('y coord (nm)')
legend('before correction','after correction')
print(strcat(name,'Correction'),'-depsc')
