function DisplayFilteredThunderSTORMResults(data_name,magnification_factor,sizestack,pixelsize,minmax,disc_frames,sigma_bound)
% Imports, filters and displays results from ThunderSTORM. 
% Events and images are discarded based on sigma values, and frames that
% were out-of-focus
% Super-resolution image is displayed as a "hot"-heatmap using boundaries from minmax
% Histogram of the localisation precision is shown and saved

ThSTORMresults=Import_ThunderSTORM_results(strcat(data_name,'_ThSTORM_Results.csv'));

Results = ThSTORMresults.frame;
Results(:,2) = ThSTORMresults.Results.x;
Results(:,3) = ThSTORMresults.Results.y;
Results(:,4) = ThSTORMresults.sigma;
Results(:,5) = ThSTORMresults.intensity;
Results(:,6) = ThSTORMresults.uncertainty;

ind1=ismember(Results(:,1),disc_frames);
Results_R2=Results(~ind1,:);
ind2 = (Results_R2(:,4)>sigma_bound(1) & Results_R2(:,4)<sigma_bound(2));
Results_R3=Results_R2(ind2,:);

sz=[magnification_factor*sizestack(2) magnification_factor*sizestack(1)];
values = hist3(magnification_factor*[Results_R3(:,3)./pixelsize Results_R3(:,2)./pixelsize],{0:sz(1)-1,0:sz(2)-1});
values(values>minmax(2))=minmax(2);
values(values<minmax(1))=minmax(1);
hot=colormap('hot');
im=ind2rgb(round((values-minmax(1))*255/(minmax(2)-minmax(1))),hot);
imwrite(im,strcat(data_name,'_SRHeatmap_Filt.tif'),'TIFF')
dipshow(values,hot)

figure
hist(Results(Results(:,6)<prctile(Results(:,6),99),6),200)
xlabel('Localisation Precision (nm)')
print(strcat(data_name,'Localisation_Precision'),'-depsc')



