function DisplayThunderSTORMResults(data_name,magnification_factor,sizestack,pixelsize)
% Imports and displays results from ThunderSTORM, unfiltered, using heatmap 'hot'

ThSTORMresults=Import_ThunderSTORM_results(strcat(data_name,'_ThSTORM_Results.csv'));

figure;
subplot(3,1,1)
hist(ThSTORMresults.uncertainty(ThSTORMresults.uncertainty<2500),500)
xlabel('Uncertainty (nm)');
subplot(3,1,2)
hist(ThSTORMresults.sigma(ThSTORMresults.uncertainty<2500),500)
xlabel('Sigma(nm)');
subplot(3,1,3)
hist(ThSTORMresults.intensity(ThSTORMresults.uncertainty<2500),500)
xlabel('Intensity (photons)');

for ii=1:ThSTORMresults.frame(end)
    nr_localisations(ii)=size(find(ThSTORMresults.frame == ii),1);
end

figure
bar(nr_localisations)
xlabel('Frame number')
ylabel('Number of localisation')

sz=[magnification_factor*sizestack(2) magnification_factor*sizestack(1)];
values = hist3(magnification_factor*[ThSTORMresults.Results.y./pixelsize ThSTORMresults.Results.x./pixelsize],{0:sz(1)-1,0:sz(2)-1});
maxmap=max(values(:));
values(values>maxmap)=maxmap;
hot=colormap('hot');
im=ind2rgb(round(values*255/maxmap),hot);
imwrite(im,strcat(data_name,'_SRHeatmap.tif'),'TIFF')
dipshow(values,hot)

figure;
hist(ThSTORMresults.sigma(ThSTORMresults.sigma<5000),500)
xlabel('Sigma(nm)');

