function Results = Import_ThunderSTORM_results(filename)
% Imports a .csv file exported by ThunderSTORM

delimiter = ',';
startRow = 2;
endRow = inf;
formatSpec = '%f%f%f%f%f%f%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');

dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(1)-1, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(block)-1, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

fclose(fileID);

% Allocate imported array to column variable names



Results.id = dataArray{:, 1};
Results.frame = dataArray{:, 2};
Results.Results.xum = dataArray{:, 3};
Results.Results.yum = dataArray{:, 4};
Results.sigmanm = dataArray{:, 5};
Results.intensityphoton = dataArray{:, 6};
Results.offsetphoton = dataArray{:, 7};
Results.bkgstdphoton = dataArray{:, 8};
Results.uncertaintynm = dataArray{:, 9};


