% Matlab script to analyse and visualise SR-cryoCLEM data, according to Tuijtel et al., 2019

    % General data
Name_data = ''; % INPUT: Provide a name for this dataset
NrImagesCycle = ; % INPUT: number of images per activation cycle
Pixelsize_nm = ;  % INPUT: pixelsize (nm) of the original data
Magn = ; % INPUT: Magnification factor of SR images compared to original data, e.g. 2
Nrbeads = ; % INPUT: Number of beads for drift correction

    % Load the cropped data
Stack = Read_Stack(Name_data);

    % Import and visualise drift from all beads isolated in ThunderSTORM
Drift=Import_ThSTORM_Drift(Nrbeads,size(Stack,3),Name_data);

    % Average drift from subset of beads to final image shifts to be applied
Bead_subset = []; % INPUT: choose a subset of beads to average
Shifts = CombineDriftBeads(Drift,Bead_subset);
save(strcat(Name_data,'_Drift.mat'),'Drift','Shifts')

    % Correct the drift based on Shifts, and save the registered stack
Stack_registered = Register_stack(Stack,Shifts,Pixelsize_nm,Name_data);

    % Optional: Check the data alignment, on selected  beads on the aligned datastack
NrBeads_aligned = ; % INPUT: number of beads to check data alignment
Bead_subset_aligned = []; % INPUT: choose a subset of beads to display
Check_Drift_correction(NrBeads_aligned,Bead_subset_aligned,size(Stack,3),Name_data,Shifts);

    % Select images directly after activation pulse
ActivationPoints = CheckActivationFrame(Stack_registered,NrImagesCycle);
ActivationPoints_offset = []; % INPUT: Select frame number with activation pulse
ActivationPoints = CheckActivationFrame(Stack_registered,NrImagesCycle,ActivationPoints_offset);
save(strcat(Name_data,'_Activation_points.mat'),'ActivationPoints')

    % Subtract images
Stack_Subtracted = SubtractActivationFrames(Stack_registered,ActivationPoints,Name_data);
Stacksize_subtracted=size(Stack_Subtracted);
save(strcat(Name_data,'_stacksize.mat'),'Stacksize_subtracted')

    % Importing ThunderSTORM data
DisplayThunderSTORMResults(Name_data,Magn,Stacksize_subtracted,Pixelsize_nm)

Heatmap_boundaries = []  % INPUT: lower and upper limit for the heatmap values, for instance: [2 60]
Discarded_images=[];  % INPUT: select images that can be discarded, for instance messy refocusing or drift
Sigma_boundaries = [];  % INPUT: select lower and upper limit for the sigma values, for instance: [30 600]
DisplayFilteredThunderSTORMResults(Name_data,Magn,Stacksize_subtracted,Pixelsize_nm,Heatmap_boundaries,Discarded_images,Sigma_boundaries)

