function stack_subtracted2 = SubtractActivationFrames(stack,framenumbers,name_data)
% Subtracts the image before an activation pulse from all images after that
% activation pulse, based on the variable framenumbers. To avoid clipping
% of the data, a constant value is added to all images prior to subtraction
dipsetpref('FileWriteWarning','off')
stack_subtracted = stack;
MinimumVal=zeros(size(framenumbers,2)+1,1);

jj=1;
for ii=1:size(framenumbers,1)
    if ii == size(framenumbers,1)
        MinimumVal(jj)=min(stack(:,:,framenumbers(ii):end)-stack(:,:,framenumbers(ii)-1));
    else
        MinimumVal(jj)=min(stack(:,:,framenumbers(ii):(framenumbers(ii+1)-1))-stack(:,:,framenumbers(ii)-1));
    end
    jj=jj+1;
end; clear jj ii

for ii=1:size(framenumbers,1)
    if ii == size(framenumbers,1)
        stack_subtracted(:,:,framenumbers(ii):end)=stack(:,:,framenumbers(ii):end)-stack(:,:,framenumbers(ii)-1)-MinVal;
    else
        stack_subtracted(:,:,framenumbers(ii):(framenumbers(ii+1)-1)) = stack(:,:,framenumbers(ii):(framenumbers(ii+1)-1))-stack(:,:,framenumbers(ii)-1)-MinVal;
    end
    disp(strcat(num2str(ii),'/',num2str(size(framenumbers,1))))
end;clear ii

for kk=(framenumbers(1)):(size(stack_subtracted,3)-1)
    filename = strcat(strcat(name_data,'_Aligned_Subtracted/'),sprintf('%05d',kk),'.tif');
    writeim(squeeze(dip_image(stack_subtracted(:,:,kk),'uint16')),filename,'tif','no');
    disp(strcat('Saving image',{' '},num2str(kk),{' '},'of',{' '},num2str(size(stack,3))))
end;clear kk

stack_subtracted2 = stack_subtracted(:,:,framenumbers(1):end);